; ====================================================
; ================= Example of a GUI =================
; ====================================================
; AutoIt version: 3.0.103
; Language:       English
; Author:         "SlimShady"
;    2017-07-08 Ric Lindberg rebuilding Example editbox.au3 to my own ting
;
; ----------------------------------------------------------------------------
; Script Start
; ----------------------------------------------------------------------------

#include <Array.au3>
#include <File.au3>
#include <Date.au3>
#include <File.au3>
#include <MsgBoxConstants.au3>
#include <GUIConstantsEx.au3>
#include <InetConstants.au3>

;The version of this script, so we know if we are up-to-date, checking this automatically but dont update automatically
 Global $ThisVersion=1  ; $PublicVersion set via SetPublicVersionNumber()


Opt("GUIOnEventMode", 1)
Global $g_idExit


;;;;; TODO List
;;; 1) Add StartTime -  Remember time of first seeing an app - so we can say your friend has been playing this X minutes (and is new starting or might be about to stop after a loong session)
;;  2) Add PlayTime (StartTime - Now)
;;  3) Post to URL instead of via SFTP

;;    https://www.autoitscript.com/autoit3/docs/functions/InetGet.htm
;;   https://www.autoitscript.com/autoit3/docs/functions/InetRead.htm
;;    https://stackoverflow.com/questions/8916658/how-to-get-specific-information-from-the-website-and-display-it-in-a-box

;
;todo
;add a label that polls online status back to the app, no external webpage required for specific user


;;

; ----------------------------------------------------------------------------
; ----------------------------------------------------------------------------
; Settings
; ----------------------------------------------------------------------------
; ----------------------------------------------------------------------------
    ;Global $SaveToPath=@ScriptDir
	Global $SaveToPath="C:\temp\IntentionConnect" ; temporary local folder to save drop-box sync
	Global $SettingsFile_ShareApps=$SaveToPath & "\\Settings_ShareStatusForThese.txt";
	Global $SettingsUserFile = $SaveToPath & "\\SettingsUserFile.txt";
	Global $Logfile_ActiveApps = $SaveToPath & "\Logfile_ActiveApps.txt"
	Global $ShareMessage_filename = $SaveToPath & "\Logfile_ShareMessageToUpload.txt"



    Global $ActiveListedFound
	Global $ActiveListedTitle
	Global $Title_from_Settings_that_matched
	Global $CurrentActiveWindowsTitle = WinGetTitle("")
	Global $CheckTime_FirstSeen
	Global $CheckTime_LastSeen
	Global $LastWindowSeen
	Global $UploadIntervalInSeconds=300 ; 300 sec = 5 minutes, 600=10min, 900=15min longer than that feels irrelevant.. or?


; ----------------------------------------------------------------------------
; ----------------------------------------------------------------------------



; Starting Programs
Global $UserName = IniRead($SettingsUserFile, "General", "UserName", "UserName_is_missing_from_Inifile" &$SettingsUserFile)
Global $UserID = IniRead($SettingsUserFile, "General", "UserID", "UserID_is_missing_from_Inifile" &$SettingsUserFile)
Global $SleepBetweenChecksInSeconds = IniRead($SettingsUserFile, "General", "SleepBetweenChecksInSeconds", "SleepBetweenChecksInSeconds_is_missing_from_Inifile" &$SettingsUserFile)

Global $webBase = "https://mightplay.com/app/status-update.php"
Global $webParametersStatic="?Usr=" & $UserName & "&UsrID=" & $UserID


Global $FileStream_Logfile_ActiveApps  = FileOpen($Logfile_ActiveApps, 1)
Global $ShareMessage = ""
Global $LastUploadDateTime ; + live counter from how long ago that was
Global $NextUploadDateTime ; + live counter from how long ago that was
Global $KnownDurationInMinutes ; aka PlayTime that we have seen in minutes
Global $CheckTime_Autoit ; When did we check, aka from when is the data I'm looking at

; ----------------------------------------------------------------------------
; ----------------------------------------------------------------------------

; Idenfity what Games or Programs we should be on the lookout for
; ignoring everything not explicitly listed to protect user privacy
; Starting with the Apps that user want to share&play with her friends


GetListOfAppsToShare_from_Settings()
SetPublicVersionNumber()



_Main()
FileClose($Logfile_ActiveApps) ;


Func _Main()
	;Initialize variables
	Local $iGUIWidth = 900, $iGUIHeight = 500
	Local $idEdit_1, $idOK_Btn, $idCancel_Btn, $iMsg

	#forceref $idEdit_1

	; ----------------------------------------------------------------------------
	; ----------------------------------------------------------------------------
	; GUI
	; ----------------------------------------------------------------------------
	; ----------------------------------------------------------------------------
	
	GUICreate("Ric MightPlay.com (" & $VersionMessage & ")", $iGUIWidth, $iGUIHeight)
	   $idNoteToFriendsEdit = GUICtrlCreateEdit("Note to friendslist about tonights game sections", 10, 10, 280, 100)
	   $idLabelShared=GUICtrlCreateLabel ("Share Status: " & "$ActiveMessage", 10, 110 , 280 , 50) ;, style = -1 [, exStyle = -1]]]] )
	   $idOK_Btn = GUICtrlCreateButton("Post Note", 10, 210, 70, 25)
	   $idFlagMightPlayTonightButton = GUICtrlCreateButton("Might Play today", 90, 210, 100, 25)
	   $idFlagWontPlayTonightButton = GUICtrlCreateButton("No Play today", 200, 210, 100, 25)
	   $idFlagPlanToPlayTonightButton = GUICtrlCreateButton("Yes, I Plan to play today", 10, 240, 280, 25)
       $idLabelUserID=GUICtrlCreateLabel ("UserID: " & $UserName, 10, 270 , 280 , 50)
       $idLabelTitle_from_Settings_that_matched=GUICtrlCreateLabel ("Title_from_Settings_that_matched:" & "$Title_from_Settings_that_matched", 10, 300 , 280 , 50)
	   $idLabelCheckTime_FirstSeen=GUICtrlCreateLabel("First Seen: starting up:", 10, 320 , 280 , 50)
	   $idLabelCheckTime_LastSeen=GUICtrlCreateLabel("Last Seen: starting up:", 10, 350 , 280 , 50)
	   $idLabelKnownDurationInMinutes=GUICtrlCreateLabel("KnownDurationInMinutes:", 10, 370 , 280 , 50)
	   
	   $idLabelCheckActiveWindowTitle=GUICtrlCreateLabel("CheckActiveWindowTitle:", 10, 400 , 280 , 50)
	   $idLabelCheckTime_Autoit=GUICtrlCreateLabel("CheckTime_Autoit : + how long ago from NOW that was", 10, 420 , 280 , 50)
	   
	   $idLabelNextUploadDateTime=GUICtrlCreateLabel("NextUploadDateTime: + when, from NOW, can we expect it", 10, 440 , 280 , 50)
	   $idLabelLastUploadDateTime=GUICtrlCreateLabel("LastUploadDateTime : + how long ago from NOW that was", 10, 460 , 280 , 50)
	   
	   GUISetOnEvent($GUI_EVENT_CLOSE, "OnExit")
	GUISetState(@SW_SHOW)

	;Loop until:
	;- user presses Esc
	;- user presses Alt+F4
	;- user clicks the close button
	While 1
		Check_if_ActiveWindow_is_Listed_For_Sharing()
		GUICtrlSetData ($idLabelShared, $ActiveMessage)
		GUICtrlSetData ($idLabelTitle_from_Settings_that_matched, "Title_from_Settings_that_matched:" & $Title_from_Settings_that_matched)
		GUICtrlSetData ($idLabelCheckTime_FirstSeen,"CheckTime_FirstSeen: " & $CheckTime_FirstSeen & " (" & $LastWindowSeen &")")
		GUICtrlSetData ($idLabelCheckTime_LastSeen,"CheckTime_LastSeen: " & $CheckTime_LastSeen)
		GUICtrlSetData ($idLabelCheckActiveWindowTitle,"Current Window: " & $CurrentActiveWindowsTitle)
		GUICtrlSetData ($idLabelCheckTime_Autoit,"CheckTime_Autoit: " & $CheckTime_Autoit)
	  ;SleepMins(1)
	  Sleep(Number($SleepBetweenChecksInSeconds)*1000)
	WEnd
EndFunc   ;==>_Main


Func Check_if_ActiveWindow_is_Listed_For_Sharing()

	; check if Current Active Title is in any of the Listed ones for Status-share
	$CurrentActiveWindowsTitle = WinGetTitle("")
	$ActiveListedFound = 0
	$ActiveListedTitle = 0
	$Title_from_Settings_that_matched = "AppNotSpecifiedForSharing"

	For $i = 0 To $NumberOfAppsToShareStatusFor
		;MsgBox($MB_SYSTEMMODAL, "DevDebugInfo", "Testing Array " & $i & " value " & $aArray_AppsToShareStatusFor[$i] & " against " & $CurrentActiveWindowsTitle)
		Local $iPosition = ""
		$iPosition = StringInStr($CurrentActiveWindowsTitle, $aArray_AppsToShareStatusFor[$i])
	   If $iPosition > 0 Then
		  $ActiveListedFound = $iPosition
		  $ActiveListedTitle = $CurrentActiveWindowsTitle
		  $Title_from_Settings_that_matched =$aArray_AppsToShareStatusFor[$i]
	   Else
	   EndIf
	Next

   Global $CheckTime_Autoit ;= _NowDate() & " " & _NowTime()
   Global $DateYYMMDD, $TimeHHMMSS, $DateTimeYYYYMMDD_HHMMSS
   Global $CheckTime_FirstSeen_TimeHHMMSS
	$DateYYMMDD = @Year & "-" & @MON & "-" & @MDAY
	$TimeHHMMSS = @HOUR & ":" & @MIN & ":" & @SEC
	Global $TimeHHMMSS_web = @HOUR & @MIN & @SEC
	$DateTimeYYYYMMDD_HHMMSS = $DateYYMMDD & " " & $TimeHHMMSS
	$CheckTime_Autoit = $DateTimeYYYYMMDD_HHMMSS
   
	if $ActiveListedFound = 0 Then
	   ;MsgBox($MB_SYSTEMMODAL, "DevDebugInfo", "Current Active Windows is NOT listed for sharing with friends " & $CurrentActiveWindowsTitle )
	   $ActiveMessage = "Current Active Windows ( " & $CurrentActiveWindowsTitle & ") is NOT listed for sharing with friends, no action taken, checked " & $CheckTime_Autoit
	   $ShareMessage = "Not Playing Any Listed Games as of " & $CheckTime_Autoit
	Else
	   $CheckTime_LastSeen = $CheckTime_Autoit
	   if not $LastWindowSeen = $CurrentActiveWindowsTitle then
		$CheckTime_FirstSeen = $CheckTime_Autoit
		$CheckTime_FirstSeen_TimeHHMMSS = $TimeHHMMSS
		$LastWindowSeen = $CurrentActiveWindowsTitle 
	   EndIf
	   $ActiveMessage = "Current Active Windows ( " & $CurrentActiveWindowsTitle & ") is listed for sharing with friends, checked " & $CheckTime_Autoit
	   ;MsgBox($MB_SYSTEMMODAL, "", "Currently Running a Listed program: " & $ActiveListedTitle )
	   ;MsgBox($MB_SYSTEMMODAL, '', "DateTime_LastFoundMatch:" & $DateTime_LastFoundMatch)
	   $ShareMessage = "Currently PLAYING " & $CurrentActiveWindowsTitle & " Come Join, updated:" & $CheckTime_Autoit
	EndIf
	; File Specification Document TODO;
	; Time of writing the line ; Datetime of writing line ; $Title_from_Settings_that_matched ; CurrentActiveWindowsTitle ; DateTime CheckTime_FirstSeen ; Time First seen (to make calulations easier) ; ActiveMessage
	_FileWriteLog($FileStream_Logfile_ActiveApps, ";" & $TimeHHMMSS & ";" & $CheckTime_Autoit & ";" & $Title_from_Settings_that_matched & ";" & $CurrentActiveWindowsTitle & ";" & $CheckTime_FirstSeen & ";" & $CheckTime_FirstSeen_TimeHHMMSS & ";" & "ActiveMessage=" & $ActiveMessage)
	_FileCreate($ShareMessage_filename)
	_FileWriteLog($ShareMessage_filename, $ShareMessage)
	
	
	Global $webParametersLive = "&AppName=" & $Title_from_Settings_that_matched & "&Time=" & $TimeHHMMSS_web
	
	Global $CompleteURL = $webBase &  $webParametersStatic & $webParametersLive
	
	_FileWriteLog($ShareMessage_filename, $CompleteURL)
	FileClose($ShareMessage_filename)
	
	;;;MsgBox($MB_SYSTEMMODAL, "Web DevDebugInfo", " webpage  " & $CompleteURL)
	
	 Local $dData = InetRead($CompleteURL, $INET_FORCERELOAD)
EndFunc ; Check_if_ActiveWindow_is_Listed_For_Sharing


Func GetListOfAppsToShare_from_Settings()
	Global $aArray_AppsToShareStatusFor = 0
	If Not _FileReadToArray($SettingsFile_ShareApps, $aArray_AppsToShareStatusFor, 0) Then
	  MsgBox($MB_SYSTEMMODAL, "", "There was an error reading the file. @error: " & @error) ; An error occurred reading the current script file.
	EndIf
	;_ArrayDisplay($aArray_AppsToShareStatusFor)

	Global $ActiveListedFound = 0;
	Global $ActiveListedTitle = "";
	Global $ActiveMessage = ""

	Global $NumberOfAppsToShareStatusFor = UBound($aArray_AppsToShareStatusFor) -1
	;MsgBox($MB_SYSTEMMODAL, "DevDebugInfo", $NumberOfAppsToShareStatusFor & " titles listed in textfile " & $SettingsFile_ShareApps)
 EndFunc ;GetListOfAppsToShare_from_Settings

Func SetPublicVersionNumber()
 Local $InetRead_dData = InetRead("https://mightplay.com/app/version.txt", $INET_FORCERELOAD)
 ; Convert the ANSI compatible binary string back into a string.
 Local $InetRead_sData = BinaryToString($InetRead_dData)
 Global $PublicVersion = $InetRead_sData
 
 Global $VersionMessage = ""
 
  if $ThisVersion = $PublicVersion Then
	;MsgBox($MB_SYSTEMMODAL, "DevDebugInfo", "Your version is the same as the public one, no need to update, version=" & $PublicVersion)
	$VersionMessage = "You have the latest version," & $PublicVersion
  Else
    $VersionMessage = "Newer version available please update, your:" & $ThisVersion & " Public:" & $PublicVersion
	MsgBox($MB_SYSTEMMODAL, "DevDebugInfo", "Your version is NOT  same as the public one, " & @CRLF & @CRLF & _
	"Recommending you update:  " &  @CRLF & @CRLF & _
	"ThisVersion=" & $ThisVersion &  @CRLF & @CRLF & _
	"PublicVersion=" & $PublicVersion &  @CRLF & @CRLF & _
	 @CRLF & @CRLF & _
	 "https://MightPlay.com/install.html")
  EndIf
EndFunc 
 

Func SleepMins($num)
    Sleep(Number($num)*60*1000)
EndFunc


Func OnExit()
	;MsgBox($MB_SYSTEMMODAL, "You clicked on", "Have a Great day today! --- Exiting now")
	Exit
EndFunc   ;==>OnExit


Func OnYes()
	MsgBox($MB_SYSTEMMODAL, "You clicked on", "Yes")
EndFunc   ;==>OnYes